#include <xtl.h>
#include <stdio.h>
#include "XBFont.h"
#include "XBFontEx.h"
#include "httpd-filehdlr.h"

const DWORD XBFONT_MAX_VERTICES = 1024 * 4;


HRESULT CXBFontEx::CreateFromEFS( const CHAR* strFontResourceFileName, DWORD dwResourceOffset )
{
    if( FAILED( m_xprResourceEx.CreateFromEFS( strFontResourceFileName, 2, NULL ) ) )
        return E_FAIL;

    return Create( m_xprResourceEx.GetTexture( dwResourceOffset ), 
                   m_xprResourceEx.GetData( dwResourceOffset + sizeof(D3DTexture) ) );
}

HRESULT CXBFontEx::DrawScaledText( FLOAT originx, FLOAT originy, FLOAT scalex, FLOAT scaley, DWORD dwColor, 
								  const WCHAR* strText, DWORD dwFlags, FLOAT fMaxPixelWidth )
{
	HRESULT rv;
	SetScaleFactors( scalex, scaley );
	rv=DrawText( originx, originy, dwColor, strText, dwFlags, fMaxPixelWidth );
	SetScaleFactors( 1.0f, 1.0f );
	return rv;
}
